/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2025 i-net software GmbH, Berlin, Germany.
**/
package rdc;

import java.net.URL;

import com.inet.report.*;

/**
 * This class explains how to add a subreport link to a subreport.
 */
public class SubreportLinkSample extends RDCSample {

    static final String MAINREPORT = "samples/rdc/mainrep.rpt";
    static final String SUBREPORT  = "samples/rdc/subrep.rpt";

    /**
     * Adds a subreport link to a subreport of an existing report.
     * @param exportFmt the output format (e.g. Engine.EXPORT_PDF)
     * @return the new engine for the report
     */
    @Override
    public Engine createAndFillEngine( String exportFmt ) {
        try {
            //create a new Engine
            Engine eng = new Engine( exportFmt );
            //load existing report to main engine
            URL reportURL = getClass().getResource( '/' + MAINREPORT );
            if( reportURL != null ) {
                eng.setReportFile( reportURL );
            } else {
                eng.setReportFile( MAINREPORT );
            }

            //get detail area and first detail section of main report
            Area area = eng.getArea( "D" );
            Section section = area.getSection( 0 );

            //add existing report as subreport
            reportURL = getClass().getResource( '/' + SUBREPORT );
            String path;
            if( reportURL != null ) {
                path = reportURL.toString();
            } else {
                path = SUBREPORT;
            }
            Subreport subrep = section.addSubreport( 100, 600, 10000, 1200, path );
            subrep.setOnDemand( true );
            subrep.setOnDemandLinkLabel( "\"subreport\"" );
            subrep.setOnDemandTabLabel( "\"subreport\"" );
            //get engine of subreport
            Engine subeng = subrep.getEngine();

            //get detail area and first detail section of subreport
            Area subArea = subeng.getArea( "D" );
            Section subSec = subArea.getSection( 0 );
            subSec.setBackColor( 0x00FFFF00 );
            //get Fields set of subreport and add DatabaseField to set
            Fields subFields = subeng.getFields();
            DatabaseField dbSubField = subFields.getDatabaseField( "Orders.CustomerID" );
            dbSubField.setValueType( Field.NUMBER );

            //get Fields set of main report and add DatabaseField to set
            Fields fields = eng.getFields();
            DatabaseField dbMainField = fields.getDatabaseField( "Customers.CustomerID" );
            dbMainField.setValueType( Field.NUMBER );

            //add a subreport link
            SubreportLink link = subrep.addSubreportLink( dbMainField, dbSubField, false );
            link.setPromptField( subFields.addPromptField( "aaa", "aaa", Field.NUMBER ) );

            return eng;
        } catch( Throwable e ) {
            e.printStackTrace();
            System.exit( 0 );
            return null;
        }
    }

    /**
     * Main method of this sample
     * @param args arguments not used
     */
    public static void main( String[] args ) {
        new SubreportLinkSample().initUI();
    }
}
